/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VWEditXMLFieldDialog
extends VWModalDialog
implements ActionListener,
IVWToolbarBorderActionListener {
    private VWToolbarBorder m_textAreaBorder = null;
    private JTextArea m_textArea = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bRuntimeData = true;
    private VWXMLData m_vwXMLData = null;

    public VWEditXMLFieldDialog(Frame parentFrame, VWXMLData vwXMLData) {
        this(parentFrame, true, vwXMLData);
    }

    public VWEditXMLFieldDialog(Frame parentFrame, boolean bRuntimeData, VWXMLData vwXMLData) {
        super(parentFrame);
        this.m_bRuntimeData = bRuntimeData;
        try {
            if (vwXMLData != null) {
                this.m_vwXMLData = new VWXMLData(vwXMLData.getXML(), vwXMLData.getSchemaName(), vwXMLData.getElementName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.layoutControls();
    }

    public VWXMLData getVWXMLData() {
        try {
            if (this.m_vwXMLData == null) {
                this.m_vwXMLData = new VWXMLData();
            }
            if (this.m_nExitStatus == 0 && this.m_textArea != null) {
                this.m_vwXMLData.setXML(this.m_textArea.getText());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_vwXMLData;
    }

    public void releaseReferences() {
        this.m_textArea = null;
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
        this.m_vwXMLData = null;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_okButton)) {
            this.m_nExitStatus = 0;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_cancelButton)) {
            this.m_nExitStatus = 1;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfwd050.htm");
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        if (event.getSource().equals(this.m_textAreaBorder)) {
            switch (event.getID()) {
                case 0x100000: {
                    try {
                        String xmlString = VWStringUtils.replaceAll(this.m_textArea.getText(), "\"\"", "\"");
                        xmlString = VWStringUtils.xmlPrettyFormat(xmlString);
                        if (!this.m_bRuntimeData) {
                            xmlString = VWStringUtils.replaceAll(xmlString, "\"", "\"\"");
                        }
                        this.m_textArea.setText(xmlString);
                        VWMessageDialog.showOptionDialog(this, VWResource.s_xmlIsWellFormed, 2);
                        break;
                    }
                    catch (Exception ex) {
                        String message = ex.getLocalizedMessage();
                        if (message == null || message.length() == 0) {
                            message = VWResource.s_xmlIsNotWellFormed;
                        }
                        VWMessageDialog.showOptionDialog(this, message, 1);
                    }
                }
            }
        }
    }

    private void layoutControls() {
        try {
            Dimension dim = VWStringUtils.stringToDimension("555,335");
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim);
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.setTitle(VWResource.s_editXMLDataFieldDialogTitle);
            this.setVisible(false);
            this.getContentPane().add((Component)this.createMainPanel(), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 2, 6);
            if (!this.m_bRuntimeData) {
                JLabel schemaLabel = new JLabel(VWResource.s_schemaName);
                VWAccessibilityHelper.setAccessibility(schemaLabel, this, VWResource.s_schemaName, VWResource.s_schemaName);
                mainPanel.add((Component)schemaLabel, gbCons);
                ++gbCons.gridx;
                gbCons.fill = 2;
                gbCons.weightx = 1.0;
                String schemaName = VWResource.s_none;
                if (this.m_vwXMLData != null && this.m_vwXMLData.getSchemaName() != null && this.m_vwXMLData.getSchemaName().length() > 0) {
                    schemaName = this.m_vwXMLData.getSchemaName();
                }
                JLabel schemaValue = new JLabel(schemaName);
                VWAccessibilityHelper.setAccessibility(schemaValue, this, schemaName, schemaName);
                mainPanel.add((Component)schemaValue, gbCons);
                gbCons.gridx = 0;
                ++gbCons.gridy;
                gbCons.fill = 0;
                gbCons.weightx = 0.0;
                gbCons.insets = new Insets(2, 6, 6, 6);
                JLabel elementLabel = new JLabel(VWResource.s_elementName);
                VWAccessibilityHelper.setAccessibility(elementLabel, this, VWResource.s_elementName, VWResource.s_elementName);
                mainPanel.add((Component)elementLabel, gbCons);
                ++gbCons.gridx;
                gbCons.fill = 2;
                gbCons.weightx = 1.0;
                String elementName = VWResource.s_none;
                if (this.m_vwXMLData != null && this.m_vwXMLData.getElementName() != null && this.m_vwXMLData.getElementName().length() > 0) {
                    elementName = this.m_vwXMLData.getElementName();
                }
                JLabel elementValue = new JLabel(elementName);
                VWAccessibilityHelper.setAccessibility(elementValue, this, elementName, elementName);
                mainPanel.add((Component)elementValue, gbCons);
            }
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 2;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_textAreaBorder = new VWToolbarBorder(VWResource.s_xmlData, 0x100000);
            this.m_textAreaBorder.addToolbarBorderActionNotifier(this);
            JPanel clientPanel = this.m_textAreaBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_textArea = new JTextArea();
            if (this.m_vwXMLData != null) {
                this.m_textArea.setText(this.m_vwXMLData.getXML());
            }
            VWAccessibilityHelper.setAccessibility(this.m_textArea, this, this.m_textArea.getText(), this.m_textArea.getText());
            clientPanel.add((Component)new JScrollPane(this.m_textArea), "Center");
            mainPanel.add((Component)this.m_textAreaBorder, gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 10;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_ok, VWResource.s_ok);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

